/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button that will be responsible for the export of the educational booklet for program item which has a live version
 * The button will be enabled only if the content has a live version
 * @private
 */
Ext.define('Ametys.plugins.odf.content.booklet.EducationalBookletController', {
    extend: 'Ametys.plugins.cms.content.controller.SmartContentController',
    
    
    _calculateStatus: function(targets)
    {
        var result = this.callParent(arguments);
        result["nolive-contents"] = [];
        
        var noLiveContentIds = [];
        Ext.Array.each(targets, function(matchingTarget) {
            var parameters = matchingTarget.getParameters();
            if (parameters.content && !parameters.additionalData.hasLiveVersion)
            {
                noLiveContentIds.push(parameters.content.getId())
            }
        }, this);
        
        var allrightContents = result["allright-contents"];
        result["allright-contents"] = []; // reset
        
        Ext.Array.each(allrightContents, function(allRightContent) {
            
            if (Ext.Array.contains(noLiveContentIds, allRightContent.id))
            {
                result["nolive-contents"].push(allRightContent);
            }
            else
            {
                result["allright-contents"].push(allRightContent);
            }
        });
        
        return result;
    },
    
    /**
     * @protected
     * Update the tooltip description according state of the current selection
     * @param description The initial description. Can be empty.
     * @param params The JSON result received
     */
    _updateTooltipDescription: function (description, params)
    {
        description = this._handlingMultiple(description, 'allright', params['allright-contents']);
        description = this._handlingMultiple(description, 'nolive', params['nolive-contents']);
        description = this._handlingMultiple(description, "locked", params['locked-contents']);
        description = this._handlingMultiple(description, "noright", params['noright-contents']);
        description = this._handlingMultiple(description, "nomodifiable", params['unmodifiable-contents']);
        description = this._handlingMultiple(description, "workflowaction", params['invalidworkflowaction-contents']);
        description = this._handlingMultiple(description, "workflowstep", params['invalidworkflowstep-contents']);
        
        this.setDescription (description);
    }
});
