<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

	<xsl:import href="container.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">container view-main</xsl:variable>     
	
	<xsl:template name="common-content-body-content">
		<xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-content-body-title-content"/>
        </xsl:variable>
		<xsl:variable name="truelevel">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable> 
        
        <div class="col-right">
			<div class="bloc brief">
				 <xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_BRIEF"/></xsl:element>
				 
				 <!-- Nombre de crédits ECTS -->
	            <xsl:if test="normalize-space(metadata/ects) != ''">
	    			<p class="ects">
			            <span class="element-name">
							<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_ECTS"/>
	    				</span>
						<xsl:text> </xsl:text>
	   					<span class="element-value"><xsl:value-of select="metadata/ects"/></span>
	    			</p>
	            </xsl:if>
	        </div>
	    </div>
    </xsl:template>
</xsl:stylesheet>