/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.catalog;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;

/**
 * The factory for Catalog objects
 */
public class CatalogFactory extends SimpleAmetysObjectFactory
{
    private CatalogModel _model;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _model = (CatalogModel) manager.lookup(CatalogModel.ROLE);
    }
    
    @Override
    public Catalog getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new Catalog(node, parentPath, this);
    }
    /**
     * Retrieves the catalog's model
     * @return the catalog's model
     */
    public CatalogModel getModel()
    {
        return _model;
    }
}
