/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.clientsideelement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.runtime.config.Config;

/**
 * Display the button only if the 'odf.publish.server' parameter is checked.
 */
public class RepublishContentClientSideElement extends StaticClientSideElement
{
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        boolean outputCdmfrPublication = Config.getInstance().getValue("odf.publish.cdm-fr.output.folder");
        boolean remoteCdmfrPublication = Config.getInstance().getValue("odf.publish.server");
        
        if (outputCdmfrPublication || remoteCdmfrPublication)
        {
            return super.getScripts(ignoreRights, contextParameters);
        }
        
        return new ArrayList<>();
    }
}
