/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.enumeration;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * Enumerator for mention type
 */
public class MentionTypeEnumerator implements Enumerator<String>, Serviceable, org.ametys.runtime.parameter.Enumerator
{
    private ContentTypeExtensionPoint _contentTypeEP;
    
    public void service(ServiceManager smanager) throws ServiceException
    {
        _contentTypeEP = (ContentTypeExtensionPoint) smanager.lookup(ContentTypeExtensionPoint.ROLE);
    }
    
    @Override
    public Map<String, I18nizableText> getTypedEntries() throws Exception
    {
        return _getEntries();
    }
    
    public Map<Object, I18nizableText> getEntries() throws Exception
    {
        return (Map<Object, I18nizableText>) (Object) _getEntries();
    }

    @Override
    public I18nizableText getEntry(String value)
    {
        return _getEntries().get(value);
    }
    
    private Map<String, I18nizableText> _getEntries()
    {
        return _contentTypeEP.getSubTypes(OdfReferenceTableHelper.ABSTRACT_MENTION)
                .stream()
                .map(cTypeId -> _contentTypeEP.getExtension(cTypeId))
                .collect(Collectors.toMap(c -> c.getId(), c -> c.getLabel()));
    }
    
    @Override
    // TODO NEWATTRIBUTEAPI: remove this method when org.ametys.runtime.parameter.Enumerator will be removed
    public Map<String, Object> getConfiguration()
    {
        return Collections.EMPTY_MAP;
    }
}
