/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.export;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.util.URIUtils;
import org.ametys.odf.catalog.Catalog;
import org.ametys.odf.catalog.CatalogsManager;

/**
 * Set the title of the catalog in response header
 */
public class SetCatalogHeader extends ServiceableAction
{
    private CatalogsManager _catalogsManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _catalogsManager = (CatalogsManager) smanager.lookup(CatalogsManager.ROLE);
    }
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        String catalogName = parameters.getParameter("catalog", "_default");
        String extension = parameters.getParameter("extension", "");
        
        Catalog catalog = catalogName.equals("_default")
                ? _catalogsManager.getDefaultCatalog()
                : _catalogsManager.getCatalog(catalogName);
        
        if (catalog == null)
        {
            throw new IllegalArgumentException("Unknown catalog with name " + catalogName);
        }
        
        Response response = ObjectModelHelper.getResponse(objectModel);
        
        // Build filename with context
        StringBuilder fileNameSB = new StringBuilder();
        fileNameSB.append(catalog.getTitle());
        String context = parameters.getParameter("context", "");
        for (String contextPart : context.split("-"))
        {
            if (StringUtils.isNotBlank(contextPart))
            {
                fileNameSB
                    .append(" ")
                    .append(contextPart);
            }
        }
        fileNameSB.append(extension);
        String fileName = fileNameSB.toString();
        
        String encodedName = URIUtils.encodeHeader(fileName);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedName + "\";filename*=UTF-8''" + encodedName);
        
        return EMPTY_MAP;
    }
}
