/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.person;

import org.ametys.cms.data.RichText;

/**
 * Class representing a {@link ContactData}
 * Information such as address, telephone, fax, email, URL etc. related to a given contact.
 *
 */
public class ContactData
{   
    /** visit Hours property : Information on when the contact is available. */
    public static final String VISIT_HOUR = "visitHour";
    /** Street property : The actual street address */
    public static final String ADDRESS = "address";
    /** Additional adress property : Extra address space. Any non-street components of the address e.g., suite number, etc */
    public static final String ADDITIONAL_ADDRESS = "additionalAddress";
    /** Zip code property. */
    public static final String ZIP_CODE = "zipCode";
    /** TOWN property. */
    public static final String TOWN = "town";
    /** PHONE property. */
    public static final String PHONE = "phone";
    /** FAX property. */
    public static final String FAX = "fax";
    /** MAIL property. */
    public static final String MAIL = "mail";
    /** WebLinkLabel property. */
    public static final String WEB_LINK_LABEL = "webLinkLabel";
    /** WebLinkUrl property. */
    public static final String WEB_LINK_URL = "webLinkUrl";
    
    private RichText _visitHour;
    private String _address;
    private String _additionalAddress;
    private String _zipCode;
    private String _town;
    private String _phone;
    private String _fax;
    private String _mail;
    private String _webLinkLabel;
    private String _webLinkUrl;
    
    /**
     * Default constructor
     */
    public ContactData()
    {
        // nothing
    }

    /**
     * Set the visit hours
     * @return the visitHour
     */
    public RichText getVisitHour()
    {
        return _visitHour;
    }

    /**
     * Get the visit hours
     * @param visitHour the visitHour to set
     */
    public void setVisitHour(RichText visitHour)
    {
        _visitHour = visitHour;
    }

    /**
     * Set the adress
     * @return the address
     */
    public String getAddress()
    {
        return _address;
    }

    /**
     * Get the adress
     * @param address the address to set
     */
    public void setAddress(String address)
    {
        _address = address;
    }

    /**
     * Set additional adress informations
     * @param additionalAddress the additionalAddress to set
     */
    public void setAdditionalAddress(String additionalAddress)
    {
        _additionalAddress = additionalAddress;
    }

    /**
     * Get additional adress informations
     * @return the additionalAddress
     */
    public String getAdditionalAddress()
    {
        return _additionalAddress;
    }

    /**
     * Set the zip code
     * @return the zipCode
     */
    public String getZipCode()
    {
        return _zipCode;
    }

    /**
     * Get the zipcode
     * @param zipCode the zipCode to set
     */
    public void setZipCode(String zipCode)
    {
        _zipCode = zipCode;
    }

    /**
     * Get the town
     * @return the town
     */
    public String getTown()
    {
        return _town;
    }

    /**
     * Set the town
     * @param town the town to set
     */
    public void setTown(String town)
    {
        _town = town;
    }

    /**
     * Get the phone number
     * @return the phone
     */
    public String getPhone()
    {
        return _phone;
    }

    /**
     * Set the phone number
     * @param phone the phone to set
     */
    public void setPhone(String phone)
    {
        _phone = phone;
    }

    /**
     * Get the fax number
     * @return the fax
     */
    public String getFax()
    {
        return _fax;
    }

    /**
     * Set the fax number
     * @param fax the fax to set
     */
    public void setFax(String fax)
    {
        _fax = fax;
    }

    /**
     * Get the email adress
     * @return the mail
     */
    public String getMail()
    {
        return _mail;
    }

    /**
     * Set the email address
     * @param mail the mail to set
     */
    public void setMail(String mail)
    {
        _mail = mail;
    }

    /**
     * Get the web link title
     * @return the webLinkLabel
     */
    public String getWebLinkLabel()
    {
        return _webLinkLabel;
    }

    /**
     * Set the weblink title
     * @param webLinkLabel the webLinkLabel to set
     */
    public void setWebLinkLabel(String webLinkLabel)
    {
        _webLinkLabel = webLinkLabel;
    }

    /**
     * Get the weblink url
     * @return the webLinkUrl
     */
    public String getWebLinkUrl()
    {
        return _webLinkUrl;
    }

    /**
     * Set the weblink url
     * @param webLinkUrl the webLinkUrl to set
     */
    public void setWebLinkUrl(String webLinkUrl)
    {
        _webLinkUrl = webLinkUrl;
    }
    
    
    
    
}
