/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program;

import java.util.Collections;
import java.util.List;

import javax.jcr.Node;

import org.ametys.cms.data.ContentDataHelper;
import org.ametys.odf.cdmfr.CDMFRTagsConstants;
import org.ametys.runtime.model.exception.UndefinedItemPathException;

/**
 * This class represent the root element of a program
 */
public class Program extends AbstractProgram<ProgramFactory>
{
    /**
     * Constructor.
     * @param node the JCR Node backing this Content.
     * @param parentPath the parent path in the Ametys hierarchy.
     * @param factory the corresponding {@link ProgramFactory}.
     */
    public Program(Node node, String parentPath, ProgramFactory factory)
    {
        super(node, parentPath, factory);
    }
    
    @Override
    public List<ProgramPart> getProgramPartParents()
    {
        return Collections.EMPTY_LIST;
    }
    
    // --------------------------------------------------------------------------------------//
    // CDMfr
    // --------------------------------------------------------------------------------------//
    @Override
    public String getCDMTagName()
    {
        return CDMFRTagsConstants.TAG_PROGRAM;
    }
    
    /**
     * Get the degree
     * @return the degree or null
     */
    public String getDegree()
    {
        try
        {
            return ContentDataHelper.getContentIdFromContentData(this, DEGREE);
        }
        catch (UndefinedItemPathException e)
        {
            return null; // this attribute is not part of model
        }
    }
}
