/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.rncp;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xml.sax.SAXException;

import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.odf.ODFHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * Client side element for abstract program RNCP sheets.
 */
public class RNCPAbstractProgramClientSideElement extends StaticClientSideElement
{
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;

    /** The ODF helper */
    protected ODFHelper _odfHelper;

    /** The RNCP model helper */
    protected RNCPModelHelper _rncpModelHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
        _odfHelper = (ODFHelper) smanager.lookup(ODFHelper.ROLE);
        _rncpModelHelper = (RNCPModelHelper) smanager.lookup(RNCPModelHelper.ROLE);
    }
    
    /**
     * Get the list of RNCP models.
     * @return A JSON list with id and label of each available RNCP model
     * @throws ConfigurationException if an error occurs
     * @throws SAXException if an error occurs
     * @throws IOException if an error occurs
     */
    @Callable
    public List<Map<String, Object>> getModels() throws ConfigurationException, SAXException, IOException
    {
        return _rncpModelHelper.getModels();
    }
}
