/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow.task;

import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.SAXException;

import org.ametys.cms.workflow.TasksGenerator;
import org.ametys.cms.workflow.WorkflowTasksComponent.Task;

/**
 * Generate the task lists with the changed values 
 */
public class TasksWithChangesGenerator extends TasksGenerator
{
    @Override
    protected void _saxAdditionalAttributes(Task task, AttributesImpl attrs) throws SAXException
    {
        super._saxAdditionalAttributes(task, attrs);
        
        if (((AbstractOdfWorkflowTasksWithChangesComponent) _tasksManager).showChanges(task))
        {
            attrs.addCDATAAttribute("showChanges", "true");
        }
        if (((AbstractOdfWorkflowTasksWithChangesComponent) _tasksManager).showImportantChanges(task))
        {
            attrs.addCDATAAttribute("showImportantChanges", "true");
        }
    }

}
