/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.observation.skill;

import org.ametys.cms.ObservationConstants;

/**
 * Observer to delete skills that became orphans after the deletion of their parent.
 * When the deleted content is a Program, delete the linked macro skills that would become orphans
 *    The deletion of macro skills will trigger the deletion of its micro skills
 * When the deleted content is a Macro skill, delete the linked micro skills that would become orphans
 */
public class DeleteContentSkillStep1Observer extends AbstractContentSkillStep1Observer
{
    @Override
    protected String getSupportedEventId()
    {
        return ObservationConstants.EVENT_CONTENT_DELETING;
    }
}
