/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.xslt;

import java.util.Map;

import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.courselist.CourseList.ChoiceType;

/**
 * DOM layer on structure of {@link CourseList}.
 */
public class CourseListElement extends AbstractODFElement<CourseList>
{
    /**
     * Constructor.
     * @param courseList the underlying {@link CourseList}.
     * @param depth Depth to SAX.
     * @param parent the parent element
     * @param odfHelper ODFHelper to resolve children easily
     */
    public CourseListElement(CourseList courseList, int depth, AbstractODFElement<?> parent, ODFHelper odfHelper)
    {
        super(courseList, depth, parent, odfHelper);
    }

    @Override
    public String getTagName()
    {
        return "courseList";
    }
    
    @Override
    protected Map<String, AmetysAttribute> _lookupAttributes()
    {
        Map<String, AmetysAttribute> result = super._lookupAttributes();
        
        result.put("title", new AmetysAttribute("title", "title", null, _object.getTitle(), this));
        
        ChoiceType type = _object.getType();
        if (type != null)
        {
            result.put("type", new AmetysAttribute("type", "type", null, type.toString(), this));
        }
        
        if (ChoiceType.CHOICE.equals(type))
        {
            result.put("min", new AmetysAttribute("min", "min", null, String.valueOf(_object.getMinNumberOfCourses()), this));
            result.put("max", new AmetysAttribute("max", "max", null, String.valueOf(_object.getMaxNumberOfCourses()), this));
        }
        
        return result;
    }
}
