/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This controller is used for the shareable course workflow buttons
 */
Ext.define('Ametys.plugins.odf.course.controllers.ShareableCourseStatusButtonController', {
    extend: 'Ametys.plugins.cms.content.controller.SmartContentController',
    
    /**
	 * @cfg {String} shareable-course-status The shareable course status of the button (none, proposed, validated)
	 */
    /**
     * @property {String} status See #cfg-shareable-course-status
     */
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        this.status = this.getInitialConfig("shareable-course-status");
		
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * @private
     * Listener handler for modified messages
     * @param {Ametys.message.Message} message the message
     */
    _onModified: function(message)
    {
        if (this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
    },
    
	_calculateStatus: function(targets)
	{
		var result = this.callParent(arguments);
		
		var allRightContents = result["allright-contents"];
		result["allright-contents"] = []; // reset all right contents
		
		if (allRightContents.length > 0)
		{
			var allRightContentIds = Ext.Array.map(allRightContents, c => c.id);
			var allRightTargets = Ext.Array.filter(targets, t => Ext.Array.contains(allRightContentIds, t.getParameters().id)); // filter targets among allowed contents
			
			// Check shareable status
			Ext.Array.each(allRightTargets, function(target) {
				var additionalData = target.getParameters().additionalData || {};
				var content = target.getParameters().content;
				if (additionalData.shareableCourseStatus && this._isActiveButton(this.status, additionalData.shareableCourseStatus))
				{
					var i18nStr = this.getConfig("allright-content-description");
                    var description = Ext.String.format(i18nStr, content.getTitle());
                    var contentParam = this._getContentDefaultParameters(content);
                    contentParam["description"] = description;
                    result["allright-contents"].push(contentParam);
				}
				else
				{
					var i18nStr = this.getConfig("workflowstep-content-description");
                    var description = Ext.String.format(i18nStr, content.getTitle());
                    var contentParam = this._getContentDefaultParameters(content);
                    contentParam["description"] = description;
                    result["invalidworkflowstep-contents"].push(contentParam);
				}
			}, this);
		}
		
		return result;
	},
	
	/**
     * @private
     * True if the button is active for the content
     * @param {String} buttonStatus The button status
     * @param {String} contentStatus The content status
     */
	_isActiveButton: function(buttonStatus, contentStatus)
	{
		if (buttonStatus == "NONE" || buttonStatus == "REFUSED")
		{
			return contentStatus != "NONE";
		}
		else if (buttonStatus == "PROPOSED")
		{
			return contentStatus == "NONE" || contentStatus == "REFUSED";
		}
		else if (buttonStatus == "VALIDATED")
		{
			return contentStatus != "VALIDATED";
		}
	}
});
