/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
Ametys.namespace('ODF', (function() {
    function trashContent(contents, mode, options)
    {
        var contentList = _contentsToList(contents);
        
        mode = mode || "single";
        
        var contentDAO = Ametys.serviceManager.lookup(org.ametys.odf.helper.DeleteODFContentHelper.ROLE);
        var result = contentDAO.trashContents(contentList, mode);
        
        if (options && options.verbose)
        {
            _logResults(result)
        }
        
        return result;
    }
    
    function deleteContent(contents, mode, options)
    {
        var contentList = _contentsToList(contents);
        
        mode = mode || "single";
        
        var contentDAO = Ametys.serviceManager.lookup(org.ametys.odf.helper.DeleteODFContentHelper.ROLE);
        var result = contentDAO.deleteContents(contentList, mode);
        
        if (options && options.verbose)
        {
            _logResults(result);
        }
        
        return result;
    }
    
    function _logResults(result)
    {
        for (var i in result)
        {
            var onecontentresult = result.get(i);
            Ametys.console.info("Concerning " + i);
            _listToConsole(onecontentresult.get('deleted-contents'), " content(s) correctly removed", 'info');
            _listToConsole(onecontentresult.get('undeleted-contents'), " content(s) not removed due to an unexpected error (see logs for details)", 'error');
            _listToConsole(onecontentresult.get('referenced-contents'), " content(s) not removed because still referenced by other contents", 'error');
            _listToConsole(onecontentresult.get('unauthorized-contents'), " content(s) not removed because your rights are insufficient", 'error');
            _listToConsole(onecontentresult.get('locked-contents'), " content(s) not removed because they are locked", 'error');
        }
    }
    
    function _contentsToList(contents)
    {
        function toArray(arg)
        {
            if (typeof arg == "object" && Array.isArray(arg))
            {
                return arg;
            }
            else
            {
                return [arg];
            }
        }

        contents = toArray(contents);
        
        var contentList = new java.util.ArrayList();
        for (var f in contents)
        {
            var content = contents[f];
            if (typeof content == 'string')
            {
                contentList.add(content);
            }
            else
            {
                contentList.add(content.getId());
            }
        }
        
        return contentList;
    }
    
    function _listToConsole(list, message, level)
    {
        if (list.size() > 0)
        {
            Ametys.console[level](list.size() + message, list);
        }
    }
    
    return {
        'trash': trashContent,
        'delete': deleteContent
    }
})());