/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.catalog;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.ametys.cms.repository.Content;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;

/**
 * The catalog copy updater to update the other ODF content attribute
 */
public class ProgramItemReferencesCopyUpdater extends AbstractProgramItemAttributeCopyUpdater
{
    @Override
    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent)
    {
        Map<Content, Content> copiedAbstractPrograms = copiedContents.keySet()
                                                                     .stream()
                                                                     .filter(AbstractProgram.class::isInstance)
                                                                     .collect(Collectors.toMap(Function.identity(), copiedContents::get));
        
        Map<Content, Content> copiedPrograms = copiedAbstractPrograms.keySet()
                                                                     .stream()
                                                                     .filter(Program.class::isInstance)
                                                                     .collect(Collectors.toMap(Function.identity(), copiedContents::get));
        
        for (Content copiedContent : copiedContents.values())
        {
            if (copiedContent instanceof AbstractProgram abstractProgram)
            {
                _updateContentAttribute(abstractProgram, "furtherStudyPrograms", copiedAbstractPrograms); // multiple - abstractProgram
                _updateContentAttribute(abstractProgram, "furtherStudyDistribution/program", copiedAbstractPrograms); // repeater / simple - abstractProgram
                abstractProgram.saveChanges();
            }
            else if (copiedContent instanceof Course course)
            {
                _updateContentAttribute(course, "shareable-programs", copiedPrograms); // multiple - container
                course.saveChanges();
            }
        }
    }
}
