/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.cdmfr;

import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.odf.program.Program;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;

/**
 * This function calls a WS on remote server to delete a Program
 * This function should be executed as a post-function of "unpublish" action
 */
public class DeleteRemoteProgramFunction extends AbstractContentWorkflowComponent implements EnhancedFunction
{
    /** The delete remote program processor */
    protected DeleteRemoteProgramProcessor _deleteRemoteProgramProcessor;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _deleteRemoteProgramProcessor = (DeleteRemoteProgramProcessor) smanager.lookup(DeleteRemoteProgramProcessor.ROLE);
    }
    
    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException
    {
        // Retrieve current content
        if (getContent(transientVars) instanceof Program program)
        {
            _deleteRemoteProgramProcessor.processPrograms(Set.of(program));
        }
    }
    
    @Override
    public FunctionType getFunctionExecType()
    {
        return FunctionType.POST;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_DELETE_REMOTE_PROGRAM_FUNCTION_LABEL");
    }
}
