/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.course.Course;
import org.ametys.odf.course.CourseFactory;
import org.ametys.odf.course.ShareableCourseHelper;
import org.ametys.odf.courselist.CourseList;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;

/**
 * OSWorkflow function for creating a {@link Course} content
 */
public class CreateCourseFunction extends AbstractCreateODFProgramItemFunction
{
    /** Constant for storing the parent course list id to use into the transient variables map. */
    public static final String COURSE_LIST_ID_KEY = AbstractCreateODFContentFunction.class.getName() + "$courseListContentId";
    
    /** Content name prefix for programs */
    public static final String CONTENT_NAME_PREFIX = "course-";

    /** The shareable course helper */
    protected ShareableCourseHelper _shareableCourseHelper;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _shareableCourseHelper = (ShareableCourseHelper) manager.lookup(ShareableCourseHelper.ROLE);
    }
    
    @Override
    protected String _getContentNamePrefix()
    {
        return CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return CourseFactory.COURSE_NODETYPE;
    }
    
    @Override
    protected void _populateAdditionalData(Map transientVars, ModifiableContent content) throws WorkflowException
    {
        super._populateAdditionalData(transientVars, content);
        
        String courseListContentId = (String) transientVars.get(COURSE_LIST_ID_KEY);
        CourseList courseListContent = StringUtils.isNotBlank(courseListContentId) ? _resolver.resolveById(courseListContentId) : null;
        
        UserIdentity user = getUser(transientVars);
        _shareableCourseHelper.initializeShareableFields((Course) content, courseListContent, user, false);
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_COURSE_FUNCTION_LABEL");
    }
}
