/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow.copy;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.content.CopyContentComponent;

/**
 * Client side element for ODF content copy.
 * See {@link org.ametys.cms.workflow.copy.CopyContentClientInteraction}
 */
public class CopyContentClientInteraction extends org.ametys.cms.workflow.copy.CopyContentClientInteraction
{
    @Override
    public void service(ServiceManager sManager) throws ServiceException
    {
        super.service(sManager);
        
        // Override the component for copy
        _copyContentComponent = (CopyContentComponent) sManager.lookup(org.ametys.odf.content.CopyContentComponent.ROLE);
    }
}
