/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This controller is used for the shareable course workflow buttons
 */
Ext.define('Ametys.plugins.odf.course.controllers.ShareableCourseStatusMenuItemController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    /**
	 * @cfg {String} shareable-course-status The shareable course status of the button (none, proposed, validated)
	 */
    /**
     * @property {String} status See #cfg-shareable-course-status
     */
    
    /**
	 * @cfg {String} on-icon-decorator-type The icon decorator type of the button
	 */
    /**
     * @property {String} onIconDecoratorType See #cfg-on-icon-decorator-type
     */
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        this.status = this.getInitialConfig("shareable-course-status");
        this.onIconDecoratorType = this.getInitialConfig("on-icon-decorator-type");
		
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * @private
     * Listener handler for modified messages
     * @param {Ametys.message.Message} message the message
     */
    _onModified: function(message)
    {
        if (this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
    },
    
    updateState: function ()
	{
		var targets = this.getMatchingTargets();

		var isEnable = false;
		var contentTitles = [];
		Ext.Array.each(targets, function(matchingTarget)
			{
				var parameters = matchingTarget.getParameters();
				if (parameters && parameters.content && parameters.additionalData)
                {
					var content = parameters.content;
					var additionalData = parameters.additionalData;
					var contentStatus = additionalData.shareableCourseStatus;
					if (contentStatus != null && (this.status == contentStatus || this.status == "NONE" && contentStatus == "REFUSED"))
					{
						// The button is enable is at least one selected course is in the good state
						isEnable = true;
						contentTitles.push(content.getTitle());
					}
                }
			},
			this
		);
	
		var description = this.description;
		description += "<br/><br/>";
		if (isEnable)
		{
			this.setIconDecoratorType(this.onIconDecoratorType);
			this.toggle(true);
			description += this.getInitialConfig("workflow-match-contents")
			description += "<br/>";
    		description += this._getContentTitles(contentTitles);
		}
		else
		{
			this.setIconDecoratorType("action-default");
			this.toggle(false);
			description += this.getInitialConfig("workflow-no-match")
			this.disable();
		}
		
		this.setDescription(description);
	},
	
	/**
     * @private
     * Get concerned content titles
     * @param {Object} contentTitles The contents' titles
     */
    _getContentTitles: function(contentTitles)
    {
		var contentTitlesAsString = "";
		Ext.Array.each(contentTitles, function(title)
			{
				if (contentTitlesAsString != "")
				{
					contentTitlesAsString += ", '" + title + "'";
			 	}
				else
				{
					contentTitlesAsString += "'" + title + "'";
				}
			}
    	);
		
		return contentTitlesAsString;
    }
});
