/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class to handle actions on OrgUnits.
 * @private
 */
Ext.define('Ametys.plugins.odf.orgunit.OrgUnitActions', {
	singleton: true,
	
	/**
	 * Opens the orgunit-search tool and the orgunit-tree tool.
	 * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
	 */
	openTools: function(controller)
	{
		Ametys.tool.ToolsManager.openTool('uitool-odf-orgunit-search', {id: controller.getInitialConfig('search-model-id')});
        
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.orgunit.RootOrgUnitProvider",
            methodName: "getRootId",
            parameters: [],
            callback: {
                handler: function(rootId) {
                    Ametys.tool.ToolsManager.openTool('uitool-odf-orgunit-tree', {treeId: controller.getInitialConfig('tree-config'), rootId: rootId})
                },
                scope: this
            },
            waitMessage: false
        });
	}
});