/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class to translate programs.
 * @private
 */
Ext.define('Ametys.plugins.odf.program.TranslateActions', {
    singleton: true,
    
    /**
     * Translate a program
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    translate: function(controller)
    {
        var targets = controller.getMatchingTargets();
        if (targets.length > 0)
        {
            var target = targets[0];
            var contentId = target.getParameters().id;
            var language = controller.code;
            Ametys.odf.program.ProgramDAO.translateProgram([contentId, language, false], this._translateProgramCb, {scope: this} );
        }
    },
    
    /**
     * Fully translate a program
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    translateFull: function(controller)
    {
        var targets = controller.getMatchingTargets();
        if (targets.length > 0)
        {
            var target = targets[0];
            var contentId = target.getParameters().id;
            var language = controller.code;
            Ametys.odf.program.ProgramDAO.translateProgram([contentId, language, true], this._translateProgramCb, {scope: this} );
        }
    },
    
    /**
     * @private
     * Callback function called after a program is translated
     * @param {Object} response The server response
     * @param {Array} args The callback arguments
     * @param {Array} params The server call parameters
     */
    _translateProgramCb: function(response, args, params)
    {
        var contentId = response["translated-program-id"];
        if (contentId)
        {
            Ametys.tool.ToolsManager.openTool('uitool-content', {id: contentId, mode: 'view'});
        }
    }
    
});