/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.JSonReader;
import org.ametys.odf.ODFHelper;

/**
 * Get the educational path information
 *
 */
public class GetEducationalPathAction extends ServiceableAction
{
    private ODFHelper _odfHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _odfHelper = (ODFHelper) smanager.lookup(ODFHelper.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        @SuppressWarnings("unchecked")
        Map<String, Object> jsParameters = (Map<String, Object>) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        
        @SuppressWarnings("unchecked")
        List<String> values = (List<String>) jsParameters.get("ids");
        
        Map<String, Object> result = new HashMap<>();
        
        List<Map<String, Object>> paths = new ArrayList<>();
        
        for (String pathIds : values)
        {
            EducationalPath educationPath = EducationalPath.of(pathIds.split(EducationalPath.PATH_SEGMENT_SEPARATOR));
            if (_odfHelper.isValid(educationPath))
            {
                paths.add(Map.of("id", pathIds, "title", _odfHelper.getEducationalPathAsString(educationPath)));
            }
            else
            {
                getLogger().warn("The educational path '" + educationPath + "' does not match any existing ODF path");
            }
        }
        
        result.put("contents", paths);
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        
        return EMPTY_MAP;
    }
}
