/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.skill;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.cms.search.ui.model.StaticSearchUIModel;

/**
 * Search UI model for skills that disables the search if skills are not enabled
 */
public class SkillSearchUIModel extends StaticSearchUIModel
{
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        // Only configure if skills are enabled
        if (ODFSkillsHelper.isSkillsEnabled())
        {
            super.configure(configuration);
        }
    }
    
    @Override
    public void dispose()
    {
        // If skills are enabled, dispose as usual, otherwise do nothing
        if (_criterionDefinitionManager != null)
        {
            _criterionDefinitionManager.dispose();
            _criterionDefinitionManager = null;
        }
    }
}
