/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * Move Live tag on CoursePart when the course is validated.
 */
public class MoveLiveTagOnCoursePartFunction extends AbstractCoursePartFunction
{
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_MOVE_LIVE_TAG_ON_COURSE_PART_FUNCTION_LABEL");
    }
    
    @Override
    protected Integer _getCoursePartActionId()
    {
        return 4;
    }
}
