/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a check box with local store for handling a boolean field with confirmation on 'yes' value. List options are: yes / no.<br>
 * If the value is set to 'yes',  ask for confirmation before setting the value and inform that the skills need a subscription to be enabled.<br>
 */
Ext.define('Ametys.odf.widget.EnableSkillsBoolean', {
    extend: "Ametys.form.widget.Checkbox",
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        this.on('change', this._confirmActivation, this);
    },

    /**
    * @private
    */
    _confirmActivation: function(me, newValue, oldValue, eOpts) {
        if (!me.duringSetValue && newValue === true)
        {
            Ametys.Msg.show({
                title: "{{i18n PLUGINS_ODF_WIDGET_ENABLESKILLS_CONFIRMATION_TITLE}}",
                msg:"{{i18n PLUGINS_ODF_WIDGET_ENABLESKILLS_CONFIRMATION_MESSAGE}}",
                icon: Ext.MessageBox.WARNING,
                buttons: Ext.Msg.OKCANCEL,
                buttonText: ['{{i18n PLUGINS_ODF_WIDGET_ENABLESKILLS_CONFIRMATION_MESSAGE_OK}}'],
                fn: function(buttonId)
                {
                    // If the user does not confirm, restore the old value
                    if (buttonId !== 'ok')
                    {
                        me.setValue(oldValue);
                    }
                }
            })
        }
    }
});
