/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a widget to select one ore more program items.<br>
 * This widget is registered for fields of type Ametys.form.WidgetManager#TYPE_CONTENT.
 */
Ext.define('Ametys.odf.widget.SelectProgramItemOfSameContext', {
    extend : 'Ametys.cms.form.widget.SelectContent',
    
    xtype: 'edition.select-program-item-of-same-context',
    
    _onStoreBeforeLoad: function(store, operation)
    {
        this.callParent(arguments);
    
        operation.setParams( Ext.apply(operation.getParams(), {
            'contextualParameters': {
                'language': this._getLanguage(),
                'contentId': this._getContentId()
            }
        }));
    },
    
    _getSearchModelParameters: function()
    {
        return Ext.apply(this.callParent(arguments), {
            contentId: this._getContentId()
        });
    },
    
    setValue: function(value)
    {
        // Reset the last query to allow store to be reload on trigger click !
        this.combobox.lastQuery = undefined;
        
        // Remove all value
        this.combobox.getStore().removeAll();
        
        this.callParent(arguments);
    },
    
    /**
     * Get content id from context
     * @private
     */
    _getContentId: function()
    {
        if (this.ownerCt && this.ownerCt.ownerCmp && this.ownerCt.ownerCmp.editingPlugin) // Grid edition
        {
            return this.ownerCt.ownerCmp.editingPlugin.context.record.getId();
        }
        else // Content tool edition
        {
            return (this._getContentInfo() || {}).id
        }
    }
});