/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Tools to search on skills
 */
Ext.define('Ametys.plugins.odf.search.SkillsSearchTool', {
    extend: 'Ametys.plugins.odf.search.ODFContentSearchTool',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        this._parentTypeId = config.parentTypeId;
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onParentEdited, this);
    },
    
    /**
     * Listener when parent content has been edited
     * Will set the tool in "out of date" mode
     * @param {Ametys.message.Message} message The edition message.
     * @protected
     */
    _onParentEdited: function (message)
    {
        var me = this;
        var targets = message.getTargets(
                function (target)
                {
                    return new RegExp("^" + Ametys.message.MessageTarget.CONTENT + "$").test(target.getId());
                }
        );
        
        if (targets.length > 0)
        {
            for (var i=0; i < targets.length; i++)
            {
                if (Ext.Array.contains(targets[i].getParameters().types, me._parentTypeId))
                {
                    me.showOutOfDate();
                    return;
                }
            }
        }
    }
});