/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This button allows to create a content and reference-it or create it as sub-content of the selected content (on a given metadata).
 * The catalog of the current selected content is set as additional workflow parameters.
 */
Ext.define('Ametys.plugins.odf.content.controller.AddShareableCourseToCurrentSelectionButtonController', {
    extend: "Ametys.plugins.odf.content.controller.AddODFContentToCurrentSelectionButtonController",
    
    _getAdditionalWorkflowParameters: function(contentId, messageType)
    {
        var params = this.callParent() || {};
        
        params['org.ametys.odf.workflow.AbstractCreateODFContentFunction$courseListContentId'] = contentId;
        return params;
    },
    
    _getAdditionalRelationsManagerParameters: function()
    {
    	var params = this.callParent() || {};
        
        params['mode'] = "create";
        return params;
    }
    
});
    