/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.enumeration;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * Enumerator for certification labels
 */
public class CertificationLabelsEnumerator implements Enumerator<String>, Serviceable
{
    private CertificationLabels _labelEnumeration;
    
    public void service(ServiceManager smanager) throws ServiceException
    {
        _labelEnumeration = (CertificationLabels) smanager.lookup(CertificationLabels.ROLE);
    }
    
    @Override
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        return _labelEnumeration.getLabels();
    }

    @Override
    public I18nizableText getEntry(String value)
    {
        return _labelEnumeration.getLabelTitle(value);
    }
}
