/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.inputdata;

import org.apache.cocoon.ProcessingException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/**
 * InputData for content pipeline.
 */
public interface ContentInputData
{
    
    /**
     * Generates SAX events for providing data to the content rendering pipeline.
     * @param handler the content handler to SAX into.
     * @throws SAXException if an error occurs while SAXing.
     * @throws ProcessingException if an error occurs during processing.
     */
    public void toSAX(ContentHandler handler) throws SAXException, ProcessingException;
    
}
