/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.skill.clientsideelement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.odf.skill.ODFSkillsHelper;

/**
 * Client side element to disable button if skills are not enabled
 */
public class SkillsCreationClientSideElement extends SkillsStaticClientSideElement
{
    /** ODF helper */
    protected ODFSkillsHelper _odfSkillsHelper;
    
    private String _rootContentPath;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _odfSkillsHelper = (ODFSkillsHelper) manager.lookup(ODFSkillsHelper.ROLE);
    }
    
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        List<Script> clonedScripts = new ArrayList<>();
        
        List<Script> scripts = super.getScripts(ignoreRights, contextParameters);
        for (Script script : scripts)
        {
            Script clonedScript = new Script(script);
            clonedScript.getParameters().put("rootContentPath", _getRootContentPath());
            clonedScripts.add(clonedScript);
        }
        
        return clonedScripts;
    }
    
    private String _getRootContentPath()
    {
        if (_rootContentPath == null)
        {
            _rootContentPath = _odfSkillsHelper.getOdfRootContentPath();
        }
        return _rootContentPath;
    }
}
