/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow;

import java.util.Map;

import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramFactory;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * OSWorkflow function for creating a {@link Program} content.
 */
public class CreateProgramFunction extends AbstractCreateODFProgramItemFunction
{
    /** Content name prefix for programs */
    public static final String CONTENT_NAME_PREFIX = "program-";
    
    @Override
    protected String _getContentNamePrefix()
    {
        return CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return ProgramFactory.PROGRAM_NODETYPE;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_PROGRAM_FUNCTION_LABEL");
    }
}
