/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow.copy;

import java.util.Map;
import java.util.Optional;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.OrgUnitFactory;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.odf.workflow.CreateOrgUnitFunction;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;

/**
 * OSWorkflow function to create a course by copy of another
 */
public class CreateOrgUnitByCopyFunction extends AbstractCreateODFContentByCopyFunction
{
    /** The RootOrgUnitProvider */
    private RootOrgUnitProvider _rootOrgUnitProvider;
    
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _rootOrgUnitProvider = (RootOrgUnitProvider) smanager.lookup(RootOrgUnitProvider.ROLE);
    }
    
    @Override
    protected String _getContentNamePrefix()
    {
        return CreateOrgUnitFunction.CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return OrgUnitFactory.ORGUNIT_NODETYPE;
    }
    
    @Override
    protected void processValues(Map transientVars, ModifiableContent targetContent, Map<String, Object> values) throws WorkflowException
    {
        super.processValues(transientVars, targetContent, values);
        
        // Set a unique CDM code
        values.put(OrgUnit.CODE_UAI, _odfHelper.generateUniqueCode(OrgUnitFactory.ORGUNIT_CONTENT_TYPE));
    }
    
    @Override
    protected Content _getParent(Map transientVars)
    {
        return Optional.ofNullable(super._getParent(transientVars))
            .filter(OrgUnit.class::isInstance)
            .orElseGet(_rootOrgUnitProvider::getRoot);
    }

    @Override
    protected boolean _isCompatibleParent(Content parent)
    {
        return parent instanceof OrgUnit;
    }

    @Override
    protected String _getParentAttributeName(Content parent)
    {
        return OrgUnit.PARENT_ORGUNIT;
    }

    @Override
    protected SynchronizableValue _buildParentSynchronizableValue(Content parent)
    {
        return new SynchronizableValue(parent.getId());
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_ORGUNIT_BY_COPY_FUNCTION_LABEL");
    }
}
