/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This button allows to create a content and reference-it or create it as sub-content of the selected content (on a given metadata).
 * The catalog of the current selected content is set as additional workflow parameters.
 */
Ext.define('Ametys.plugins.odf.content.controller.AddODFContentToCurrentSelectionButtonController', {
    extend: "Ametys.plugins.contentstree.AddContentToCurrentSelectionButtonController",
   
    /**
     * @property {String} _currentCatalogName The name of catalog of the current selected content. 
     */
     
    act: function(result, args, contentId, messageType)
    {
        // Get the catalog and orgunits of the current content
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.ODFHelper",
            methodName: "getProgramItemInfo",
            parameters: [contentId, args.contentPathIds],
            callback: {
                handler: this._getContentInfoCb,
                scope: this,
                arguments: [result, args, contentId, messageType]
            },
            waitMessage: false
        });
    },
    
    /**
     * @private
     * Callback function invoked after retrieving the current catalog and orgunits.
     * Retains the current catalog to set it as additional workflow parameters later.
     * @param {String} catalogName The catalog name
     * @param {Object[]} args The arguments received on #act and that will be transmitted to parent act method
     */
    _getContentInfoCb: function(info, args)
    {
        var catalogName = info.catalog;
        var orgUnits = info.orgUnits;
        
        this._currentCatalogName = catalogName;
        
        args = Ext.Array.push(args, {'catalog': catalogName}); // Force catalog value in creation metadata set if exists
        args = Ext.Array.push(args, null); // for force mode
        args = Ext.Array.push(args, {'orgUnit': orgUnits}); // Init orgunit value in creation metadata set if exists

        Ametys.plugins.contentstree.AddContentToCurrentSelectionButtonController.prototype.act.apply(this, args);
    },
    
    /**
     * Add the current catalog if not null to the additional workflow parameters
     * @param {String} contentId The currently selected content identifier
     * @param {String} messageType The bus message type (such as 'content')
     * @return {Object} the additional workflow parameters
     */
    _getAdditionalWorkflowParameters: function(contentId, messageType)
    {
        var params = this.callParent() || {};
        params['org.ametys.odf.workflow.AbstractCreateODFContentFunction$catalog'] = this._currentCatalogName;
        return params;
    }
    
});
    