/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.inputdata;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

/**
 * Generates SAX events from activated input data.
 */
public class ContentInputDataGenerator extends ServiceableGenerator
{
    
    private ContentInputDataExtensionPoint _inputDataExtensionPoint;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _inputDataExtensionPoint = (ContentInputDataExtensionPoint) serviceManager.lookup(ContentInputDataExtensionPoint.ROLE);
    }

    @Override
    public void generate() throws SAXException, ProcessingException
    {
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "inputData");
        
        _inputDataExtensionPoint.toSAX(contentHandler);
        
        XMLUtils.endElement(contentHandler, "inputData");
        contentHandler.endDocument();
    }
    
}
