/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.rights;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.rights.ContentRightAssignmentContext;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.RootOrgUnitProvider;

/**
 * {@link RightAssignmentContext} for assign rights to a {@link OrgUnit}
 */
public class ODFRightAssignmentContext extends ContentRightAssignmentContext
{
    /** The Right assignment context id */
    @SuppressWarnings("hiding")
    public static final String ID = "right.assignment.context.orgunit";
    
    private RootOrgUnitProvider _orgUnitProvider;
    private ODFHelper _odfHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _orgUnitProvider = (RootOrgUnitProvider) smanager.lookup(RootOrgUnitProvider.ROLE);
        _odfHelper = (ODFHelper) smanager.lookup(ODFHelper.ROLE);
    }
    
    @Override
    public Set<Object> getParentContexts(Object context)
    {
        if (context instanceof OrgUnit)
        {
            return Collections.singleton(((OrgUnit) context).getParentOrgUnit());
        }
        
        return super.getParentContexts(context);
    }

    @Override
    public List<Object> getRootContexts(Map<String, Object> contextParameters)
    {
        List<Object> rootContexts = super.getRootContexts(contextParameters);
        
        if (matchWorkspace(contextParameters))
        {
            rootContexts.add(_orgUnitProvider.getRoot());
        }
        return rootContexts;
    }
    
    @Override
    protected Object getRootContent()
    {
        return _odfHelper.getRootContent();
    }
}
