/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.tree;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.core.ui.StaticFileImportsClientSideElement;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Abstract class for a static {@link ODFTreeIndicator}
 *
 */
public abstract class AbstractStaticODFTreeIndicator extends StaticFileImportsClientSideElement implements ODFTreeIndicator
{
    private I18nizableText _label;
    private I18nizableText _description;
    private String _iconGlyph;
    private int _priority;
    private String _matchFn;
    private String _applyFn;
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        super.configure(configuration);
        
        Configuration labelConf = configuration.getChild("label");
        _label = I18nizableText.getI18nizableTextValue(labelConf, "plugin." + _pluginName, labelConf.getValue(_id));
        
        Configuration descConf = configuration.getChild("description");
        _description = I18nizableText.getI18nizableTextValue(descConf, "plugin." + _pluginName, descConf.getValue(""));
        
        _iconGlyph = configuration.getChild("icon-glyph").getValue();
        
        _priority = configuration.getChild("priority").getValueAsInteger(50);
        
        _matchFn = configuration.getChild("matchFn").getValue(null);
        _applyFn = configuration.getChild("applyFn").getValue(null);
    }
    
    public int getPriority()
    {
        return _priority;
    }
    
    public I18nizableText getLabel()
    {
        return _label;
    }
    
    public I18nizableText getDescription()
    {
        return _description;
    }
    
    public String getIconGlyph()
    {
        return _iconGlyph;
    }
    
    public String getMatchJSFunction()
    {
        return _matchFn;
    }
    
    public String getApplyJSFunction()
    {
        return _applyFn;
    }
}
