/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow.copy;

import java.util.Map;

import org.ametys.cms.repository.Content;
import org.ametys.odf.person.PersonFactory;
import org.ametys.odf.workflow.CreatePersonFunction;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * OSWorkflow function to create a course by copy of another
 */
public class CreatePersonByCopyFunction extends AbstractCreateODFContentByCopyFunction
{
    @Override
    protected String _getContentNamePrefix()
    {
        return CreatePersonFunction.CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return PersonFactory.PERSON_NODETYPE;
    }
    
    @Override
    protected Content _getParent(Map transientVars)
    {
        return null;
    }

    @Override
    protected boolean _isCompatibleParent(Content parent)
    {
        throw new UnsupportedOperationException("This method should not been called in this function.");
    }

    @Override
    protected String _getParentAttributeName(Content parent)
    {
        throw new UnsupportedOperationException("This method should not been called in this function.");
    }

    @Override
    protected SynchronizableValue _buildParentSynchronizableValue(Content parent)
    {
        throw new UnsupportedOperationException("This method should not been called in this function.");
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_PERSON_BY_COPY_FUNCTION_LABEL");
    }
}
