<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:cms="http://ametys.org/cms/3.0" >

	<xsl:import href="orgunit.xsl"/>
    <xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">orgunit view-main</xsl:variable>
	
    <xsl:template name="common-content-body-content">
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-content-body-title-content"/>
        </xsl:variable>
        <xsl:variable name="truelevel">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>    
    
        <div class="col-content">
            <!-- Présentation -->        
			<xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/description"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_ORGUNIT_DESCRIPTION'"/>
            </xsl:call-template> 
       
            <!-- Admission -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/admissionInfo"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_ORGUNIT_ADMISSION'"/>
            </xsl:call-template> 
            
            <!-- Réglement -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/regulations"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_ORGUNIT_REGULATIONS'"/>
            </xsl:call-template> 
            
            <!-- Coût -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/expenses"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_ORGUNIT_EXPENSES'"/>
            </xsl:call-template> 
            
            <!-- Aménagements -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/universalAdjustment"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_ORGUNIT_UNIVERSAL_ADJUSTMENT'"/>
            </xsl:call-template> 
            
            <!-- Vie étudiante --> 
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/studentFacilities"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_ORGUNIT_STUDENT_FACILITIES'"/>
            </xsl:call-template> 
                        
            <!-- Informations complémentaires -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/additionalInfos"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_ORGUNIT_ADDITIONAL_INFOS'"/>
            </xsl:call-template> 
        </div>         
        
        <div class="col-right">
            <xsl:call-template name="contacts">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
            <xsl:call-template name="more-info">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>            
        </div>   
        <div class="col-end"/>        
	</xsl:template>
	
	<!-- +
	     | RIGHT CONTENT : Contacts
	     + -->
	<xsl:template name="contacts">
        <xsl:param name="truelevel"/>
    
        <xsl:if test="metadata/contactsReferences">
    		<div class="bloc contact">
    			<xsl:element name="h{$truelevel}"><i18n:text i18n:key="CONTENT_PROGRAM_PERSON_CONTACT"/></xsl:element>
                
                <xsl:for-each select="metadata/contactsReferences">
                     <xsl:variable name="contactId" select="@id"/>
                     <xsl:apply-templates select="//persons/contactsReferences/content[@id = $contactId]/html/body/node()" mode="move-hierarchy">
                         <xsl:with-param name="level" select="$truelevel + 2"/>
                    </xsl:apply-templates>  
                </xsl:for-each>
    		</div>
        </xsl:if>
	</xsl:template>

    
    <!-- +
         | RIGHT CONTENT : En savoir plus
         + -->
    <xsl:template name="more-info">
        <xsl:param name="truelevel"/>
    
        <xsl:if test="normalize-space(metadata/webLinkUrl) != ''">
            <div class="bloc siteurl">
                <xsl:element name="h{$truelevel}"><i18n:text i18n:key="CONTENT_PROGRAM_WEB_LINK_TITLE"/></xsl:element>
                <p>
                    <a href="{metadata/webLinkUrl}">
                        <xsl:choose>
                            <xsl:when test="metadata/webLinkLabel != ''"><xsl:value-of select="metadata/webLinkLabel"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="metadata/webLinkUrl"/></xsl:otherwise>
                        </xsl:choose>                    
                    </a>    
                </p>
            </div>
        </xsl:if>   
    </xsl:template>    
	
</xsl:stylesheet>