/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.observation;

import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.cdmfr.DeleteRemoteProgramProcessor;
import org.ametys.odf.program.Program;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Observes {@link Program} content deletion in order to synchronize with remote server
 */
public class RemoteProgramDeletedObserver extends AbstractLogEnabled implements Observer, Serviceable
{
    /** The delete remote program processor */
    protected DeleteRemoteProgramProcessor _deleteRemoteProgramProcessor;

    public void service(ServiceManager smanager) throws ServiceException
    {
        _deleteRemoteProgramProcessor = (DeleteRemoteProgramProcessor) smanager.lookup(DeleteRemoteProgramProcessor.ROLE);
    }
    
    @Override
    public boolean supports(Event event)
    {
        if (event.getId().equals(ObservationConstants.EVENT_CONTENT_DELETING) && (boolean) Config.getInstance().getValue("odf.publish.server"))
        {
            Content content = (Content) event.getArguments().get(ObservationConstants.ARGS_CONTENT);
            return content instanceof Program;
        }
        
        return false;
    }

    @Override
    public int getPriority()
    {
        return 0;
    }

    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Program program = (Program) event.getArguments().get(ObservationConstants.ARGS_CONTENT);
        _deleteRemoteProgramProcessor.processPrograms(Set.of(program));
    }

}
