/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.orgunit;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.repository.ContentFactory;
import org.ametys.cms.repository.ModifiableContentFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;

/**
 * {@link ContentFactory} for handling {@link OrgUnit}
 */
public class OrgUnitFactory extends ModifiableContentFactory
{
    /** {@link OrgUnit} nodetype for resources collection */
    public static final String ORGUNIT_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":orgunitContent";

    /** {@link OrgUnit} content type */
    public static final String ORGUNIT_CONTENT_TYPE = "org.ametys.plugins.odf.Content.orgunit";

    /** The root OrgUnit node name */
    public static final String ODF_ORGUNIT_ROOT_NODE = "root-orgunit";

    private RootOrgUnitProvider _rootOrgUnitProvider;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _rootOrgUnitProvider = (RootOrgUnitProvider) manager.lookup(RootOrgUnitProvider.ROLE);
    }
    
    @Override
    public OrgUnit getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new OrgUnit(node, parentPath, this);
    }

    String _getRootOrgUnitUAI()
    {
        return _rootOrgUnitProvider.getRoot().getUAICode();
    }
}
