/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
let config = org.ametys.runtime.config.Config.getInstance();
let rightDataBaseId = config.getValue('runtime.rights.datasource');
let rights = {};
  
let rs = SQL.query("SELECT * FROM Rights_ProfileRights", rightDataBaseId);
while (rs.next())
{
    let profile = rs.getString("Profile_Id");
    if (!rights[profile])
    {
        rights[profile] = [];
    }
    let rightId = rs.getString("Right_Id");
    rights[profile].push(rightId);
}

let hasChanges = false;  
for (let profile in rights)
{
   let rightIds = rights[profile];
    
   let hasSkillsRights = deleteIfExist(profile, rightIds, "ODF_Rights_Skills_Add");
   hasSkillsRights = deleteIfExist(profile, rightIds, "ODF_Rights_Skill_Delete") || hasSkillsRights;
   hasSkillsRights = deleteIfExist(profile, rightIds, "ODF_Rights_Skills_Import") || hasSkillsRights;
   hasSkillsRights = deleteIfExist(profile, rightIds, "ODF_Rights_Skills_Export") || hasSkillsRights;
     
   if (hasSkillsRights)
   {
       insertRight(profile, "ODF_Rights_Skills_Handle");
       hasChanges = true;
   }
}

if (hasChanges)
{
    logger.info("Migration needs a restart of the application");
    // The application requires a restart because the RightProfilesDAO's cache needs to be cleared
    actionData.setRequiresRestart(true);
}
  
function deleteIfExist(profile, rightIds, rightId)
{
   if (rightIds.indexOf(rightId) != -1)
   {
       let nbChanges = SQL.update("DELETE FROM Rights_ProfileRights "
              + "WHERE Profile_Id='" + profile + "' "
              + "AND Right_Id='" + rightId + "'",
       rightDataBaseId);
       
       logger.info("Delete right '" + rightId + "' for profile '" + profile + "'");
       return nbChanges > 0;
   }
    
   return false;
}
  
function insertRight(profile, rightId)
{
   SQL.update("INSERT INTO Rights_ProfileRights "
            + "VALUES ('" + profile + "','" + rightId + "')",
   rightDataBaseId); 
    
   logger.info("Add right '" + rightId + "' for profile '" + profile + "'");
}
