/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow.copy;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.course.Course;
import org.ametys.odf.course.CourseFactory;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.workflow.CreateCourseFunction;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;

/**
 * OSWorkflow function to create a course by copy of another
 */
public class CreateCourseByCopyFunction extends AbstractCreateProgramItemByCopyFunction
{
    @Override
    protected String _getContentNamePrefix()
    {
        return CreateCourseFunction.CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return CourseFactory.COURSE_NODETYPE;
    }
    
    @Override
    protected Set<String> _getChildrenReferencesName()
    {
        return Set.of(Course.CHILD_COURSE_LISTS);
    }

    @Override
    protected Map<String, Object> getAdditionalCopyMap(Map transientVars, Content baseContent, String viewName, String fallbackViewName) throws WorkflowException
    {
        Map<String, Object> copyMap = super.getAdditionalCopyMap(transientVars, baseContent, viewName, fallbackViewName);
        ModifiableContent targetContent = (ModifiableContent) getResultsMap(transientVars).get(CONTENT_KEY);
        
        // Always copy courseParts
        Map<String, Object> childReferenceMap = new HashMap<>();
        childReferenceMap.put("$mode", "create");
        childReferenceMap.put(CreateCoursePartByCopyFunction.COURSE_HOLDER_KEY, targetContent.getId());
        copyMap.put(Course.CHILD_COURSE_PARTS, childReferenceMap);
        
        return copyMap;
    }

    @Override
    protected boolean _isCompatibleParent(Content parent)
    {
        return parent instanceof CourseList;
    }

    @Override
    protected String _getParentAttributeName(Content parent)
    {
        return Course.PARENT_COURSE_LISTS;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_COURSE_BY_COPY_FUNCTION_LABEL");
    }
}
