/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Tools to search on "my programs"
 */
Ext.define('Ametys.plugins.odf.search.MyProgramsSearchTool', {
    extend: 'Ametys.plugins.cms.search.ContentSearchTool',

	// Disable grouping feature
    enableGroupingMenu: false,
    
    // Override group template to ignore column name
    groupHeaderTpl: [
            '{name:this.formatName}',
            {
                formatName: function(name) {
                    return Ext.String.trim(name.toString());
                }
            }
        ],
                
    statics: {
        
        /**
	     * Convert a content value for model.
	     * Content values can be of two kinds
	     * @param {String/String[]/Object/Object[]} value If it is an object, it will return the 'id' property.  
	     * @param {String} value.id The id
	     * @param {Ext.data.Model} record The record
	     * @param {String} dataIndex The model data index
	     * @return {String/String[]} The ids only
	     */
	    convertPrimaryOdfContentType: function(value, record, dataIndex)
	    {
            var properties = {};
            record.data[dataIndex + "_full"] = properties;
            
            if (Ext.isObject(value))
	        {
	            properties[value.id] = value;
	            value = value.id;
	        }
            
            return value;
	    },
        
        /**
         * Render for the ODF content type value
         * @param {Object} value The data value
         * @param {Object} metaData A collection of metadata about the current cell
         * @param {Ext.data.Model} record The record
         * @param {Number} rowIndex The index of the current row
         * @param {Number} colIndex The index of the current column
         * @param {Ext.data.Store} store The data store
         * @param {Ext.view.View} view The current view
         * @param {String} dataIndex The data index of the column
         */
        renderPrimaryOdfContentType: function(value, metaData, record, rowIndex, colIndex, store, view, dataIndex)
        {
            if (Ext.isEmpty(value))
	        {
	            return '';
	        }
            
            var inGroup = (dataIndex == null);
            dataIndex = inGroup ? rowIndex : dataIndex; // When used by grouping feature, data index is the 4th arguments
	        
	        var values = Ext.isArray(value) ? value : [value];
	        var html = '';
	
	        var properties = record.get((dataIndex) + "_full");
            var property = properties ? properties[value] : null;
	        if (property)
	        {
	            return property.label;
	        }
            
            return value;
        }
    },
    
    _getStoreCfg: function()
    {
        return Ext.apply(this.callParent(), {
            groupField: 'odfPrimaryContentType'
        });
    }
});

