/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.xslt;

import java.util.Map;

import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.program.Container;

/**
 * DOM layer on structure of {@link Container}.
 */
public class ContainerElement extends AbstractODFElement<Container>
{
    /**
     * Constructor.
     * @param container the underlying {@link Container}.
     * @param depth Depth to SAX.
     * @param parent Parent of the element
     * @param odfHelper ODFHelper to resolve children easily
     */
    public ContainerElement(Container container, int depth, AbstractODFElement<?> parent, ODFHelper odfHelper)
    {
        super(container, depth, parent, odfHelper);
    }

    @Override
    public String getTagName()
    {
        return "container";
    }
    
    @Override
    protected Map<String, AmetysAttribute> _lookupAttributes()
    {
        Map<String, AmetysAttribute> result = super._lookupAttributes();
        
        result.put("title", new AmetysAttribute("title", "title", null, _object.getTitle(), this));
        
        double ects = _object.getEcts();
        if (ects > 0)
        {
            result.put("ects", new AmetysAttribute("ects", "ects", null, String.valueOf(ects), this));
        }
        
        return result;
    }
}
