/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


let contents = Repository.query(`//element(*, ametys:content)[@ametys-internal:contentType = 'org.ametys.plugins.odf.Content.container']`);
let total = contents.getSize();
let handled = 0;

contents.forEach(
    content =>
    {
        Content.migrate( 
            content, 
            [_changeContainerCardinality], 
            true, /* old version still comptatible */ 
            null, /* no tag */ 
            false, /* verbose */
            true /* synchronize live */
        );
        
        handled++;
        if (handled % 500 == 0)
        {
            logger.info(`${handled}/${total} handled containers`);
        }
    }
);
logger.info(`${handled} container(s) has been updated to change cardinality of containers orgunits`);

function _changeContainerCardinality(content)
{
    Repository.helper.convertSingleToMultipleProperty(content.getNode(), "ametys:orgUnit");
    Repository.helper.convertSingleToMultipleProperty(content.getNode(), "ametys:orgUnit__alt");
}
