/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button representing the default state of a catalog
 * @private
 */
Ext.define('Ametys.plugins.odf.catalog.DefaultCatalogController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this.refreshIfMatchingMessage, this);
    },

    updateState: function()
    {
        var target = this.getMatchingTargets()[0];
        
        this.toggle(target.getParameters().isDefault);
        this.setDisabled(target.getParameters().isDefault);
        this.setIconDecorator (target.getParameters().isDefault ? 'decorator-ametysicon-check34' : null);
        this.setAdditionalDescription(target.getParameters().isDefault ? "{{i18n PLUGINS_ODF_CATALOG_SET_DEFAULT_DEFAULT_DESCRIPTION}}" : null);
    }
});
