/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class overrides the default relation handler to do some additional checks before setting relations
 */
Ext.define("Ametys.plugins.odf.relations.SetContentAttributeRelationHandler", {
    override: "Ametys.plugins.cms.relations.SetContentAttributeRelationHandler",
   
    statics: {
        
        getEducationalPathReferences: function(contentIdsToReference, contentIdsToEditToRemove, callback, callbackArgs, scope)
        {
            Ametys.data.ServerComm.callMethod({
                    role: "org.ametys.core.ui.RelationsManager",
                    id: "org.ametys.cms.relations.setcontentattribute",
                    methodName: "getEducationalPathReferences",
                    parameters: [
                        contentIdsToReference,
                        contentIdsToEditToRemove
                    ],
                    callback: {
                        handler: function(response, args) {
                            if (response && response.educationalPathReferences && response.educationalPathReferences.length > 0)
                            {
                                var confirmMsg = Ametys.plugins.cms.relations.SetContentAttributeRelationHandler._buildConfirMsg(response.contentToRemove, response.educationalPathReferences);
                                
                                Ametys.Msg.confirm(
                                    "{{i18n PLUGINS_ODF_OBSOLETE_EDUCATIONAL_PATHS_CONFIRM_TITLE}}",
                                    confirmMsg,
                                    function (answer)
                                    {
                                        if (answer == 'yes')
                                        {
                                            callback.apply(scope || this, callbackArgs || []);
                                        }
                                    },
                                    this
                                );
                            }
                            else
                            {
                                callback.apply(scope, callbackArgs);
                            }
                        },
                        arguments: []
                    },
                    waitMessage: true,
                    errorMessage: true
                });
        },
        
        /**
         * Build the list of content with education paths references
         * @param {Object} refContent The content that part of the education paths references
         * @param {String} refContent.id The id of referenced content
         * @param {String} refContent.title The title of referenced content
         * @param {Object[]} educationalPathReferences The contents with education path(s) that refers the content
         * @param {String} educationalPathReferences.id The id of content with education path(s) that refers the content
         * @param {String} educationalPathReferences.code The id of content with education path(s) that refers the content
         * @param {String} educationalPathReferences.title The id of content with education path(s) that refers the content
         * @param {Object} educationalPathReferences.educationalPath The educational path that refers the content with following properties:
         * @param {Object} educationalPathReferences.educationalPath.value The value of educational path
         * @param {Object} educationalPathReferences.educationalPath.repeaterLabel The label of repeater holding this educational path
         */
        _buildConfirMsg: function(refContent, educationalPathReferences)
	    {
	        var confirmMsg = Ext.String.format("{{i18n PLUGINS_ODF_OBSOLETE_EDUCATIONAL_PATHS_CONFIRM_MSG_1}}", refContent.title);
	            
	        confirmMsg += '<ul style="max-height: 250px; overflow-y: auto">';
	                
	        Ext.Array.each(educationalPathReferences, function(educationalPathReferences) {
	            var href = "javascript:(function(){parent.Ametys.tool.ToolsManager.openTool('uitool-content', {id:'" + educationalPathReferences.id + "'});})()";
	            confirmMsg += '<li><a href="' + href + '">' + educationalPathReferences.title + (educationalPathReferences.code ? ' (' + educationalPathReferences.code + ')' : '') + '</a>';
	            
	            confirmMsg += "<ul>"
	            Ext.Array.each(educationalPathReferences.educationalPaths, function(educationalPath, index) {
	                confirmMsg += "<li>" + educationalPath.repeaterLabel + "</li>"
	            });
	            
	            confirmMsg += '</ul></li>';
	        });
	        confirmMsg += "</ul>"
	        confirmMsg += "{{i18n PLUGINS_ODF_OBSOLETE_EDUCATIONAL_PATHS_CONFIRM_MSG_2}}";
	        
	        return confirmMsg;
	    }
        
    },
    
    /**
     * @private
     */
    _linkChoiceCb: function(attributePath, callback, contentIdsToReference, contentIdsToEdit, positionInTargets, contentIdsToEditByType, contentIdsToEditToRemove, button)
    {
        if (attributePath == null || (button && (button == 'no' || button == 'cancel')))
        {
            callback(false);
            return;
        }
        
        if (contentIdsToEditToRemove.length == 0)
        {
            this.callParent(arguments);
        }
        else
        {
            // Check before move or remove if moved or removed contents is referenced in some education paths
            // Callback this.linkChoiceCb of overriden class if every is fine or the user confirm the move/remove
            Ametys.plugins.cms.relations.SetContentAttributeRelationHandler.getEducationalPathReferences(contentIdsToReference, contentIdsToEditToRemove, this._linkChoiceCb.$previous, arguments, this);
        }
    }
});