/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton to import csv skills as the children of the selected content
 * @private
 */
Ext.define('Ametys.plugins.odf.skills.SkillsCSVImportActions',{
    singleton: true,
    
    /**
     * This action imports simple contents from a CSV file
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    importCSVUnderSelectedParent: function (controller)
    {
        // Get the root content path (needed for creation)
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.skill.ODFSkillsHelper",
            methodName: "getOdfRootContentPath",
            callback: {
                handler: this._importCSVUnderSelectedParentCb,
                scope: this,
                arguments: {"controller" : controller}
            },
            errorMessage:true,
            waitMessage: false
        });
    },
    
    _importCSVUnderSelectedParentCb: function (response, args)
    {
        var additionalParams = {
            "additionalTransientVars" : {
                "org.ametys.cms.workflow.CreateContentFunction$rootContentPath" : response
            },
            "serverRole" : "org.ametys.odf.skill.imports.csv.ImportSkillsCSVFile",
            "helperServerRole" : "org.ametys.odf.skill.imports.csv.ImportSkillsCSVFileHelper"
        };
        
        Ametys.plugins.contentio.SelectionAwareConfigurableImportCSVActions.importCSVUnderSelectedParent(args.controller, additionalParams);
    },
    
    /**
     * This action imports simple contents from a CSV file
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    importCSV: function (controller)
    {
        // Get the root content path (needed for creation)
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.skill.ODFSkillsHelper",
            methodName: "getOdfRootContentPath",
            callback: {
                handler: this._importCSVCb,
                scope: this,
                arguments: {"controller" : controller}
            },
            errorMessage:true,
            waitMessage: false
        });
    },
    
    _importCSVCb: function (response, args)
    {
        var additionalParams = {
            "additionalTransientVars" : {
                "org.ametys.cms.workflow.CreateContentFunction$rootContentPath" : response
            },
            "serverRole" : "org.ametys.odf.skill.imports.csv.ImportSkillsCSVFile",
            "helperServerRole" : "org.ametys.odf.skill.imports.csv.ImportSkillsCSVFileHelper"
        };
        
        Ametys.plugins.contentio.SelectionAwareConfigurableImportCSVActions.importCSV(args.controller, additionalParams);
    },
})