/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button to export skills as CSV.
 * @private
 */
Ext.define('Ametys.plugins.odf.skills.SkillsExportActions', {
    singleton: true,
    /**
     * Export skills
     */
    exportCSV: function()
    {
        this._delayedInitialize();
        this._box.show();
        this._initForm();
    },

    /**
     * @private
     * Creates the dialog box
     */
    _delayedInitialize: function ()
    {
        if (!this._initialized)
        {
            this._formPanel = this._createFormPanel();
            
            this._box = Ext.create('Ametys.window.DialogBox', {
                title: "{{i18n plugin.odf:PLUGINS_ODF_DIALOG_SKILLS_EXPORT_TITLE}}",
                iconCls: 'ametysicon-desktop-book',
                
                width: 450,
                scrollable: false,
                
                items: [this._formPanel],
                
                defaultFocus: 'title',
                closeAction: 'hide',
                buttons: [{
                    text: "{{i18n plugin.odf:PLUGINS_ODF_DIALOG_SKILLS_EXPORT_BUTTON_OK}}",
                    handler: Ext.bind(this._validate, this)
                }, {
                    text: "{{i18n plugin.odf:PLUGINS_ODF_DIALOG_SKILLS_EXPORT_BUTTON_CANCEL}}",
                    handler: Ext.bind( function() {this._box.close();}, this)
                }]    
            });
            
            this._initialized = true;
        }
    },

    /**
     * Creates the form panel of this dialog box.
     * @return {Ext.form.Panel} The form panel
     * @private
     */
    _createFormPanel: function()
    {
        var formPanel = Ext.create('Ext.form.Panel', {
            defaultType: 'combo',
            defaults: {
                cls: 'ametys',
                labelSeparator: '',
                labelAlign: 'right',
                labelWidth: 150,
                width: '100%',
                msgTarget: 'side'
            },
            
            border: false,
            scrollable: true,
            
            items: [
                {
                    xtype: 'container',
                    itemId: 'hint',
                    html: "{{i18n plugin.odf:PLUGINS_ODF_DIALOG_SKILLS_EXPORT_HINT}}",
                    cls: 'a-text'
                },
                Ametys.odf.catalog.CatalogDAO.createComboBox({
                    name: 'catalog',
                    fieldLabel: "* {{i18n plugin.odf:PLUGINS_ODF_EXPORT_CATALOG_INDESIGN_DIALOGBOX_CATALOG}}",
                    itemId: 'catalog',
                    allowBlank: false
                })
            ]
            
        });
        
        return formPanel;
    },

    /**
     * @private
     * Initializes the form with some optional values.
     */
    _initForm: function ()
    {
        var form = this._formPanel.getForm();
        form.reset();
        
        Ametys.odf.catalog.CatalogDAO.getDefaultCatalogName([], function(catalogName) {
            form.findField('catalog').setValue(catalogName)
        }, this);
    },

    /**
     * @private
     * Handler for the 'ok' button of the dialog box
     */ 
    _validate: function ()
    {
        var form = this._formPanel.getForm();
        if (!form.isValid())
        {
            return;
        }
        
        var values = form.getValues();
        
        var appParameters = Ametys.getAppParameters();
        Ext.Object.each(appParameters, function(key, value) {
            values[key] = value;
        });
        
        Ametys.openWindow(Ametys.getPluginDirectPrefix('odf') + '/skills/export.csv', values);
        
        this._box.close();
    }
});